/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.resultcondition;

import com.taotao.boot.common.extension.CollectionUtils;
import com.taotao.boot.common.utils.common.ArgUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordContext;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResult;
import com.taotao.boot.sensitive.sensitiveword.api.IWordTag;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordValidModeEnum;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.AbstractWordResultCondition;
import java.util.Collection;
import java.util.Set;

public class WordResultConditionWordTagsMatch
extends AbstractWordResultCondition {
    private final Collection<String> tags;

    public WordResultConditionWordTagsMatch(Collection<String> tags) {
        ArgUtils.notEmpty(tags, (String)"tags");
        this.tags = tags;
    }

    @Override
    protected boolean doMatch(IWordResult wordResult, String text, WordValidModeEnum modeEnum, IWordContext context) {
        String word = text.substring(wordResult.startIndex(), wordResult.endIndex());
        IWordTag wordTag = context.wordTag();
        Set<String> wordTags = wordTag.getTag(word);
        if (CollectionUtils.isEmpty(wordTags)) {
            return false;
        }
        for (String tag : this.tags) {
            if (!wordTags.contains(tag)) continue;
            return true;
        }
        return false;
    }
}

