/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.resultcondition;

import com.taotao.boot.common.support.pipeline.Pipeline;
import com.taotao.boot.common.utils.collection.ArrayUtils;
import com.taotao.boot.common.utils.common.ArgUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResultCondition;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.WordResultConditionAlwaysTrue;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.WordResultConditionEnglishWordMatch;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.WordResultConditionEnglishWordNumMatch;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.WordResultConditionInit;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.WordResultConditionWordTagsMatch;
import java.util.List;

public final class WordResultConditions {
    public static IWordResultCondition alwaysTrue() {
        return new WordResultConditionAlwaysTrue();
    }

    public static IWordResultCondition englishWordMatch() {
        return new WordResultConditionEnglishWordMatch();
    }

    public static IWordResultCondition englishWordNumMatch() {
        return new WordResultConditionEnglishWordNumMatch();
    }

    public static IWordResultCondition wordTags(List<String> tags) {
        ArgUtils.notEmpty(tags, (String)"tags");
        return new WordResultConditionWordTagsMatch(tags);
    }

    public static IWordResultCondition chains(final IWordResultCondition condition, final IWordResultCondition ... others) {
        return new WordResultConditionInit(){

            @Override
            protected void init(Pipeline<IWordResultCondition> pipeline) {
                pipeline.addLast((Object)condition);
                if (ArrayUtils.isNotEmpty((Object[])others)) {
                    for (IWordResultCondition other : others) {
                        pipeline.addLast((Object)other);
                    }
                }
            }
        };
    }
}

