/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.tag;

import com.taotao.boot.common.utils.common.ArgUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordTag;
import com.taotao.boot.sensitive.sensitiveword.support.tag.AbstractWordTag;
import com.taotao.boot.sensitive.sensitiveword.support.tag.WordTags;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WordTagLines
extends AbstractWordTag {
    private final IWordTag wordTag;
    private final String wordSplit;
    private final String tagSplit;

    public WordTagLines(Collection<String> lines, String wordSplit, String tagSplit) {
        ArgUtils.notNull(lines, (String)"lines");
        ArgUtils.notEmpty((String)wordSplit, (String)"wordSplit");
        ArgUtils.notEmpty((String)tagSplit, (String)"tagSplit");
        this.wordSplit = wordSplit;
        this.tagSplit = tagSplit;
        Map<String, Set<String>> wordTagMap = this.buildWordTagMap(lines);
        this.wordTag = WordTags.map(wordTagMap);
    }

    public WordTagLines(Collection<String> lines) {
        this(lines, " ", ",");
    }

    private Map<String, Set<String>> buildWordTagMap(Collection<String> lines) {
        HashMap<String, Set<String>> wordTagMap = new HashMap<String, Set<String>>();
        for (String line : lines) {
            String[] strings = line.split(this.wordSplit);
            String key = strings[0];
            HashSet tags = new HashSet(StringUtils.splitToList((String)strings[1], (String)this.tagSplit));
            wordTagMap.put(key, tags);
        }
        return wordTagMap;
    }

    @Override
    protected Set<String> doGetTag(String word) {
        return this.wordTag.getTag(word);
    }
}

