/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivewords.configuration;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sensitive.desensitize.DesensitizeProperties;
import com.taotao.boot.sensitive.sensitivewords.SensitiveWordsRunner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={RedisRepository.class})
@EnableConfigurationProperties(value={DesensitizeProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.sensitive", name={"enabled"}, havingValue="true")
public class SensitiveAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SensitiveAutoConfiguration.class, (String)"taotao-boot-starter-sensitive", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnBean(value={RedisRepository.class})
    public SensitiveWordsRunner sensitiveWordsRunner(RedisRepository redisRepository) {
        return new SensitiveWordsRunner(redisRepository);
    }
}

