/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sentinel.configuration;

import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.RequestOriginParser;
import com.taotao.boot.common.model.Result;
import com.taotao.boot.common.utils.common.JsonUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sentinel.properties.SentinelProperties;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@AutoConfiguration
@EnableConfigurationProperties(value={SentinelProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.sentinel", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SentinelAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(SentinelAutoConfiguration.class, (String)"taotao-boot-starter-sentinel", (String[])new String[0]);
    }

    @Bean
    public RequestOriginParser requestOriginParser() {
        return new HeaderRequestOriginParser();
    }

    public static class HeaderRequestOriginParser
    implements RequestOriginParser {
        private static final String ALLOW = "Allow";

        public String parseOrigin(HttpServletRequest request) {
            return request.getHeader(ALLOW);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpServletRequest.class})
    public static class WebmvcHandler {
        @Bean
        public BlockExceptionHandler webmvcBlockExceptionHandler() {
            return (request, response, str, e) -> {
                response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
                Result result = Result.fail((String)"Too many request, please retry later.");
                response.getWriter().print(JsonUtils.toJson((Object)result));
            };
        }
    }
}

