/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sentinel.spi;

import com.alibaba.csp.sentinel.command.handler.ModifyParamFlowRulesCommandHandler;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.FileRefreshableDataSource;
import com.alibaba.csp.sentinel.datasource.FileWritableDataSource;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.transport.util.WritableDataSourceRegistry;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FileDataSourceInit
implements InitFunc {
    private Converter<String, List<FlowRule>> flowRuleListParser = source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(this){}, (Feature[])new Feature[0]);
    private Converter<String, List<DegradeRule>> degradeRuleListParser = source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<DegradeRule>>(this){}, (Feature[])new Feature[0]);
    private Converter<String, List<SystemRule>> systemRuleListParser = source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<SystemRule>>(this){}, (Feature[])new Feature[0]);
    private Converter<String, List<AuthorityRule>> authorityRuleListParser = source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<AuthorityRule>>(this){}, (Feature[])new Feature[0]);
    private Converter<String, List<ParamFlowRule>> paramFlowRuleListParser = source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ParamFlowRule>>(this){}, (Feature[])new Feature[0]);

    public void init() throws Exception {
        String ruleDir = System.getProperty("user.home") + "/sentinel/rules";
        String flowRulePath = ruleDir + "/flow-rule.json";
        String degradeRulePath = ruleDir + "/degrade-rule.json";
        String paramFlowRulePath = ruleDir + "/param-flow-rule.json";
        String systemRulePath = ruleDir + "/system-rule.json";
        String authorityRulePath = ruleDir + "/authority-rule.json";
        this.mkdirIfNotExits(ruleDir);
        this.createFileIfNotExits(flowRulePath);
        this.createFileIfNotExits(degradeRulePath);
        this.createFileIfNotExits(paramFlowRulePath);
        this.createFileIfNotExits(systemRulePath);
        this.createFileIfNotExits(authorityRulePath);
        FileRefreshableDataSource flowRuleRDS = new FileRefreshableDataSource(flowRulePath, this.flowRuleListParser);
        FlowRuleManager.register2Property((SentinelProperty)flowRuleRDS.getProperty());
        FileWritableDataSource flowRuleWDS = new FileWritableDataSource(flowRulePath, this::encodeJson);
        WritableDataSourceRegistry.registerFlowDataSource((WritableDataSource)flowRuleWDS);
        FileRefreshableDataSource degradeRuleRDS = new FileRefreshableDataSource(degradeRulePath, this.degradeRuleListParser);
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleRDS.getProperty());
        FileWritableDataSource degradeRuleWDS = new FileWritableDataSource(degradeRulePath, this::encodeJson);
        WritableDataSourceRegistry.registerDegradeDataSource((WritableDataSource)degradeRuleWDS);
        FileRefreshableDataSource paramFlowRuleRDS = new FileRefreshableDataSource(paramFlowRulePath, this.paramFlowRuleListParser);
        ParamFlowRuleManager.register2Property((SentinelProperty)paramFlowRuleRDS.getProperty());
        FileWritableDataSource paramFlowRuleWDS = new FileWritableDataSource(paramFlowRulePath, this::encodeJson);
        ModifyParamFlowRulesCommandHandler.setWritableDataSource((WritableDataSource)paramFlowRuleWDS);
        FileRefreshableDataSource systemRuleRDS = new FileRefreshableDataSource(systemRulePath, this.systemRuleListParser);
        SystemRuleManager.register2Property((SentinelProperty)systemRuleRDS.getProperty());
        FileWritableDataSource systemRuleWDS = new FileWritableDataSource(systemRulePath, this::encodeJson);
        WritableDataSourceRegistry.registerSystemDataSource((WritableDataSource)systemRuleWDS);
        FileRefreshableDataSource authorityRuleRDS = new FileRefreshableDataSource(authorityRulePath, this.authorityRuleListParser);
        AuthorityRuleManager.register2Property((SentinelProperty)authorityRuleRDS.getProperty());
        FileWritableDataSource authorityRuleWDS = new FileWritableDataSource(authorityRulePath, this::encodeJson);
        WritableDataSourceRegistry.registerAuthorityDataSource((WritableDataSource)authorityRuleWDS);
    }

    private void mkdirIfNotExits(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void createFileIfNotExits(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    private <T> String encodeJson(T t) {
        return JSON.toJSONString(t);
    }
}

