/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.third.client.forest.client;

import com.dtflys.forest.annotation.BaseRequest;
import com.dtflys.forest.annotation.DataFile;
import com.dtflys.forest.annotation.Get;
import com.dtflys.forest.annotation.JSONBody;
import com.dtflys.forest.annotation.LogHandler;
import com.dtflys.forest.annotation.Post;
import com.dtflys.forest.annotation.Retry;
import com.dtflys.forest.annotation.Retryer;
import com.dtflys.forest.annotation.Success;
import com.dtflys.forest.annotation.Var;
import com.dtflys.forest.annotation.XMLBody;
import com.dtflys.forest.callback.OnProgress;
import com.dtflys.forest.extensions.BasicAuth;
import com.dtflys.forest.extensions.DownloadFile;
import com.dtflys.forest.extensions.OAuth2;
import com.dtflys.forest.http.ForestRequest;
import com.taotao.boot.third.client.forest.config.MyLogHandler;
import com.taotao.boot.third.client.forest.config.MyRetryCondition;
import com.taotao.boot.third.client.forest.config.MyRetryer;
import com.taotao.boot.third.client.forest.config.MySuccessCondition;
import java.io.File;
import java.util.List;
import java.util.Map;

@BaseRequest(baseURL="http://127.0.0.1:8080/hello")
public interface TestAmapClient {
    @Get(value="http://ditu.amap.com/service/regeo?longitude={0}&latitude={1}")
    @Retry(maxRetryCount="3", maxRetryInterval="10", condition=MyRetryCondition.class)
    @Retryer(value=MyRetryer.class)
    @LogHandler(value=MyLogHandler.class)
    @Success(condition=MySuccessCondition.class)
    public Map getLocation(String var1, String var2);

    @Post(value="/test/json")
    public String postJsonMap(@JSONBody Map var1);

    @Post(value="/test/json")
    public String postJsonText(@JSONBody String var1);

    @Post(value="/test/xml")
    public String postXmlBodyString(@XMLBody String var1);

    @Post(value="/upload")
    public Map upload(@DataFile(value="file") String var1, OnProgress var2);

    @Post(value="/upload")
    public ForestRequest<Map> uploadByteArrayMap(@DataFile(value="file", fileName="{_key}") Map<String, byte[]> var1);

    @Post(value="/upload")
    public ForestRequest<Map> uploadByteArrayList(@DataFile(value="file", fileName="test-img-{_index}.jpg") List<byte[]> var1);

    @Get(value="http://127.0.0.1:8080/images/xxx.jpg")
    @DownloadFile(dir="{0}")
    public File downloadFile(String var1, OnProgress var2);

    @Post(value="/hello/user?username={username}")
    @BasicAuth(username="{username}", password="bar")
    public String send(@Var(value="username") String var1);

    @OAuth2(tokenUri="/auth/oauth/token", clientId="password", clientSecret="xxxxx-yyyyy-zzzzz", grantType=OAuth2.GrantType.PASSWORD, scope="any", username="root", password="xxxxxx")
    @Get(value="/test/data")
    public String getData();
}

