/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.third.client.webclient.http;

import com.taotao.boot.third.client.webclient.http.PmsBrandApi;
import com.taotao.boot.third.client.webclient.http.TokenHolder;
import com.taotao.boot.third.client.webclient.http.UmsAdminApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientAdapter;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;

public class HttpInterfaceConfig {
    @Value(value="${remote.baseUrl}")
    private String baseUrl;
    private final TokenHolder tokenHolder;

    public HttpInterfaceConfig(TokenHolder tokenHolder) {
        this.tokenHolder = tokenHolder;
    }

    @Bean
    WebClient webClient() {
        return WebClient.builder().defaultHeader("source", new String[]{"http-interface"}).filter((request, next) -> {
            ClientRequest filtered = ClientRequest.from((ClientRequest)request).header("Authorization", new String[]{this.tokenHolder.getToken()}).build();
            return next.exchange(filtered);
        }).baseUrl(this.baseUrl).build();
    }

    @Bean
    UmsAdminApi umsAdminApi(WebClient client) {
        HttpServiceProxyFactory factory = HttpServiceProxyFactory.builderFor((HttpExchangeAdapter)WebClientAdapter.create((WebClient)client)).build();
        return (UmsAdminApi)factory.createClient(UmsAdminApi.class);
    }

    @Bean
    PmsBrandApi pmsBrandApi(WebClient client) {
        HttpServiceProxyFactory factory = HttpServiceProxyFactory.builder().exchangeAdapter((HttpExchangeAdapter)WebClientAdapter.create((WebClient)client)).build();
        return (PmsBrandApi)factory.createClient(PmsBrandApi.class);
    }
}

