/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.tracer;

import io.micrometer.context.ContextExecutorService;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextScheduledExecutorService;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ContextSnapshots {
    public static final ContextSnapshotFactory CONTEXT_SNAPSHOT_FACTORY = ContextSnapshotFactory.builder().contextRegistry(ContextRegistry.getInstance()).clearMissing(false).captureKeyPredicate(key -> true).build();

    public static Supplier<ContextSnapshot> supplier() {
        return () -> CONTEXT_SNAPSHOT_FACTORY.captureAll(new Object[0]);
    }

    public static ContextSnapshot contextSnapshot() {
        return CONTEXT_SNAPSHOT_FACTORY.captureAll(new Object[0]);
    }

    public static Runnable wrap(Runnable runnable) {
        return ContextSnapshots.contextSnapshot().wrap(runnable);
    }

    public static <T> Callable<T> wrap(Callable<T> callable) {
        return ContextSnapshots.contextSnapshot().wrap(callable);
    }

    public static <T> Consumer<T> wrap(Consumer<T> consumer) {
        return ContextSnapshots.contextSnapshot().wrap(consumer);
    }

    public static Executor wrap(Executor executor) {
        return ContextSnapshots.contextSnapshot().wrapExecutor(executor);
    }

    public static ExecutorService wrap(ExecutorService service) {
        return ContextExecutorService.wrap((ExecutorService)service, ContextSnapshots.supplier());
    }

    public static ScheduledExecutorService wrap(ScheduledExecutorService service) {
        return ContextScheduledExecutorService.wrap((ScheduledExecutorService)service, ContextSnapshots.supplier());
    }
}

