/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.tracer.autoconfigure;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.tracer.properties.MicrometerProperties;
import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.common.annotation.ValueResolver;
import io.micrometer.core.aop.CountedAspect;
import io.micrometer.core.aop.MeterTagAnnotationHandler;
import io.micrometer.core.instrument.MeterRegistry;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;

@EnableConfigurationProperties(value={MicrometerProperties.class})
@Configuration(proxyBeanMethods=false)
public class TtcMicrometerAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(TtcMicrometerAutoConfiguration.class, (String)"taotao-boot-starter-tracer", (String[])new String[0]);
    }

    @Bean
    public MeterTagAnnotationHandler meterTagAnnotationHandler() {
        return new MeterTagAnnotationHandler(valueResolverClass -> new ValueResolver(this){

            public String resolve(Object parameter) {
                LogUtils.info((String)"parameter: {}", (Object[])new Object[]{parameter});
                return parameter.toString();
            }
        }, valueExpressionResolverClass -> new ValueExpressionResolver(this){

            public String resolve(String expression, Object parameter) {
                LogUtils.info((String)"expression: {}, parameter: {}", (Object[])new Object[]{expression, parameter});
                return parameter.toString();
            }
        });
    }

    @Bean
    public CountedAspect countedAspect(MeterRegistry meterRegistry) {
        return new CountedAspect(meterRegistry, this::skipNonControllers);
    }

    private boolean skipNonControllers(ProceedingJoinPoint pjp) {
        Class<?> targetClass = pjp.getTarget().getClass();
        return AnnotationUtils.findAnnotation(targetClass, Controller.class) == null;
    }
}

