/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.translation.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.translation.annotation.TranslationType;
import com.taotao.boot.translation.core.TranslationInterface;
import com.taotao.boot.translation.core.handler.TranslationBeanSerializerModifier;
import com.taotao.boot.translation.core.handler.TranslationHandler;
import com.taotao.boot.translation.properties.TranslationProperties;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={TranslationProperties.class})
@AutoConfiguration
public class TranslationConfig
implements InitializingBean {
    private final List<TranslationInterface<?>> list;
    private final ObjectMapper objectMapper;

    public TranslationConfig(List<TranslationInterface<?>> list, ObjectMapper objectMapper) {
        this.list = list;
        this.objectMapper = objectMapper;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(TranslationConfig.class, (String)"taotao-boot-starter-translation", (String[])new String[0]);
    }

    @PostConstruct
    public void init() {
        HashMap map = new HashMap(this.list.size());
        for (TranslationInterface<?> trans : this.list) {
            if (trans.getClass().isAnnotationPresent(TranslationType.class)) {
                TranslationType annotation = trans.getClass().getAnnotation(TranslationType.class);
                map.put(annotation.type(), trans);
                continue;
            }
            LogUtils.warn((String)(trans.getClass().getName() + " \u7ffb\u8bd1\u5b9e\u73b0\u7c7b\u672a\u6807\u6ce8 TranslationType \u6ce8\u89e3!"), (Object[])new Object[0]);
        }
        TranslationHandler.TRANSLATION_MAPPER.putAll(map);
        this.objectMapper.setSerializerFactory(this.objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new TranslationBeanSerializerModifier()));
    }
}

