/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.translation.core.handler;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.taotao.boot.common.utils.reflect.ReflectUtils;
import com.taotao.boot.translation.annotation.Translation;
import com.taotao.boot.translation.core.TranslationInterface;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.util.ObjUtil;

public class TranslationHandler
extends JsonSerializer<Object>
implements ContextualSerializer {
    public static final Map<String, TranslationInterface<?>> TRANSLATION_MAPPER = new ConcurrentHashMap();
    private Translation translation;

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        TranslationInterface<?> trans = TRANSLATION_MAPPER.get(this.translation.type());
        if (ObjUtil.isNotNull(trans)) {
            if (StringUtils.isNotBlank((CharSequence)this.translation.mapper())) {
                value = ReflectUtils.invokeGetter((Object)gen.currentValue(), (String)this.translation.mapper());
            }
            if (ObjUtil.isNull((Object)value)) {
                gen.writeNull();
                return;
            }
            Object result = trans.translation(value, this.translation.other());
            gen.writeObject(result);
        } else {
            gen.writeObject(value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Translation translation = (Translation)property.getAnnotation(Translation.class);
        if (Objects.nonNull(translation)) {
            this.translation = translation;
            return this;
        }
        return prov.findValueSerializer(property.getType(), property);
    }
}

