/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.translation.other.aop;

import com.taotao.boot.translation.other.annotaion.TranslationResult;
import com.taotao.boot.translation.other.handler.TranslationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.stereotype.Component;

@Component
public class TranslationInterceptor
implements MethodInterceptor {
    private final List<TranslationHandler> translationHandlers;

    public TranslationInterceptor(List<TranslationHandler> translationHandlers) {
        this.translationHandlers = translationHandlers;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (Objects.isNull(invocation)) {
            return null;
        }
        Class cls = AopProxyUtils.ultimateTargetClass((Object)invocation.getThis());
        if (!cls.equals(invocation.getThis().getClass())) {
            return invocation.proceed();
        }
        TranslationResult translationResult = invocation.getMethod().getAnnotation(TranslationResult.class);
        Object proceed = invocation.proceed();
        if (Objects.isNull(proceed) || !translationResult.enable()) {
            return null;
        }
        Type returnType = TypeUtil.getReturnType((Method)invocation.getMethod());
        for (TranslationHandler translationHandler : this.translationHandlers) {
            if (!translationHandler.adaptation(returnType)) continue;
            translationHandler.translation(proceed, returnType, translationResult);
        }
        return proceed;
    }
}

