/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.translation.other.cache;

import com.taotao.boot.translation.other.annotaion.Translate;
import com.taotao.boot.translation.other.annotaion.TranslationResult;
import com.taotao.boot.translation.other.cache.TranslationCacheLocal;
import com.taotao.boot.translation.other.domain.ConvertInfo;
import com.taotao.boot.translation.other.service.DictTranslationService;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.springframework.stereotype.Service;

@Service
public class TranslationCacheService {
    private final DictTranslationService dictTranslationService;

    public TranslationCacheService(DictTranslationService dictTranslationService) {
        this.dictTranslationService = dictTranslationService;
    }

    public void initCache(Collection<?> objects) {
        objects.forEach(this::initCache0);
        this.cacheTranslation();
    }

    public void initCache(Object object) {
        this.initCache0(object);
        this.cacheTranslation();
    }

    private void initCache0(Object object) {
        Object fieldValue;
        if (Objects.isNull(object)) {
            return;
        }
        List<ConvertInfo> list = Arrays.stream(BeanUtil.getPropertyDescriptors(object.getClass())).map(this::initCache0).toList();
        List<ConvertInfo> translationResults = list.stream().filter(o -> Objects.nonNull(o.getTranslationResult())).toList();
        for (ConvertInfo translationResult : translationResults) {
            fieldValue = BeanUtil.getProperty((Object)object, (String)translationResult.getName());
            if (!Objects.nonNull(fieldValue)) continue;
            if (fieldValue instanceof Collection) {
                ((Collection)fieldValue).forEach(this::initCache0);
            }
            this.initCache0(fieldValue);
        }
        for (ConvertInfo convertInfo : list) {
            fieldValue = BeanUtil.getProperty((Object)object, (String)convertInfo.getField().getName());
            Translate translate = convertInfo.getTranslate();
            if (Objects.isNull(fieldValue) || Objects.isNull(translate)) continue;
            if (fieldValue instanceof Collection) {
                ((Collection)fieldValue).forEach(o -> this.addCacheInfo(translate, o));
                continue;
            }
            this.addCacheInfo(translate, fieldValue);
        }
    }

    private void addCacheInfo(Translate translate, Object fieldValue) {
        TranslationCacheLocal.Cache cache = TranslationCacheLocal.get();
        switch (translate.type()) {
            case DICT: {
                cache.addDict(translate.dicCode(), fieldValue.toString());
                break;
            }
        }
    }

    private ConvertInfo initCache0(PropertyDescriptor descriptor) {
        Field field = FieldUtil.getField(descriptor.getReadMethod().getDeclaringClass(), (String)descriptor.getName());
        Translate translate = (Translate)AnnotationUtil.getAnnotation((AnnotatedElement)field, Translate.class);
        TranslationResult translationResult = (TranslationResult)AnnotationUtil.getAnnotation((AnnotatedElement)field, TranslationResult.class);
        ConvertInfo convertInfo = new ConvertInfo();
        convertInfo.setName(descriptor.getName());
        convertInfo.setField(field);
        convertInfo.setTranslate(translate);
        convertInfo.setTranslationResult(translationResult);
        return convertInfo;
    }

    private void cacheTranslation() {
        this.dictTranslationService.initDictTranslationCache();
    }
}

