/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.translation.other.service;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.translation.other.annotaion.Translate;
import com.taotao.boot.translation.other.annotaion.TranslationResult;
import com.taotao.boot.translation.other.cache.TranslationCacheLocal;
import com.taotao.boot.translation.other.cache.TranslationCacheService;
import com.taotao.boot.translation.other.domain.ConvertInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.stereotype.Service;

@Service
public class FieldTranslationService {
    private final TranslationCacheService translationCacheService;

    public FieldTranslationService(TranslationCacheService translationCacheService) {
        this.translationCacheService = translationCacheService;
    }

    public void translation(Collection<?> objects) {
        this.translationCacheService.initCache(objects);
        objects.forEach(this::translation0);
    }

    public void translation(Object object) {
        this.translationCacheService.initCache(object);
        this.translation0(object);
    }

    private void translation0(Object object) {
        if (Objects.isNull(object)) {
            return;
        }
        List<ConvertInfo> list = Arrays.stream(BeanUtil.getPropertyDescriptors(object.getClass())).map(this::initConvertInfo).toList();
        List<ConvertInfo> translationResults = list.stream().filter(o -> Objects.nonNull(o.getTranslationResult())).toList();
        for (ConvertInfo translationResult : translationResults) {
            Object fieldValue = BeanUtil.getProperty((Object)object, (String)translationResult.getName());
            if (!Objects.nonNull(fieldValue)) continue;
            if (fieldValue instanceof Collection) {
                ((Collection)fieldValue).forEach(this::translation0);
            }
            this.translation0(fieldValue);
        }
        list.stream().filter(o -> Objects.nonNull(o.getTranslate())).peek(convertInfo -> this.isAndGetFieldType((ConvertInfo)convertInfo, object)).forEach(o -> this.translation0((ConvertInfo)o, object));
    }

    private Class<?> isAndGetFieldType(ConvertInfo convertInfo, Object convertObject) {
        Object value;
        Object fieldValue;
        Translate translate = convertInfo.getTranslate();
        if (StrUtil.isAllEmpty((CharSequence[])new CharSequence[]{translate.source(), translate.target()}) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)convertInfo.getName())) && Objects.nonNull(value = this.getTranslationValue(translate, fieldValue)) && !ClassUtil.isAssignable(convertInfo.getField().getType(), value.getClass())) {
            return value.getClass();
        }
        return null;
    }

    private void translation0(ConvertInfo convertInfo, Object convertObject) {
        Object dictValue;
        Object fieldValue;
        Translate translate = convertInfo.getTranslate();
        if (StrUtil.isAllEmpty((CharSequence[])new CharSequence[]{translate.source(), translate.target()}) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)convertInfo.getName()))) {
            dictValue = this.getTranslationValue(translate, fieldValue);
            this.setFieldValue(convertObject, convertInfo.getName(), dictValue);
        }
        if (StrUtil.isNotBlank((CharSequence)translate.source()) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)translate.source()))) {
            dictValue = this.getTranslationValue(translate, fieldValue);
            this.setFieldValue(convertObject, convertInfo.getName(), dictValue);
        }
        if (StrUtil.isNotBlank((CharSequence)translate.target()) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)convertInfo.getName()))) {
            dictValue = this.getTranslationValue(translate, fieldValue);
            this.setFieldValue(convertObject, translate.target(), dictValue);
        }
    }

    private ConvertInfo initConvertInfo(PropertyDescriptor descriptor) {
        Field field = FieldUtil.getField(descriptor.getReadMethod().getDeclaringClass(), (String)descriptor.getName());
        Translate translate = (Translate)AnnotationUtil.getAnnotation((AnnotatedElement)field, Translate.class);
        TranslationResult translationResult = (TranslationResult)AnnotationUtil.getAnnotation((AnnotatedElement)field, TranslationResult.class);
        ConvertInfo convertInfo = new ConvertInfo();
        convertInfo.setName(descriptor.getName());
        convertInfo.setField(field);
        convertInfo.setTranslate(translate);
        convertInfo.setTranslationResult(translationResult);
        return convertInfo;
    }

    public Collection<Map<String, Object>> translationToMap(Collection<?> objects) {
        this.translationCacheService.initCache(objects);
        return objects.stream().map(o -> this.translationToMap0(o)).toList();
    }

    public Map<String, Object> translationToMap(Object object) {
        this.translationCacheService.initCache(object);
        return this.translationToMap0(object);
    }

    private Map<String, Object> translationToMap0(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        this.translationCacheService.initCache(object);
        Map map = BeanUtil.beanToMap((Object)object, (String[])new String[0]);
        Map convertInfoMap = Arrays.stream(BeanUtil.getPropertyDescriptors(object.getClass())).map(this::initConvertInfo).collect(Collectors.toMap(ConvertInfo::getName, Function.identity(), (o1, o2) -> o2));
        convertInfoMap.values().stream().filter(o -> Objects.nonNull(o.getTranslationResult())).forEach(o -> {
            Object fieldValue = BeanUtil.getProperty((Object)object, (String)o.getName());
            if (Objects.nonNull(fieldValue)) {
                map.put(o.getName(), this.translationToMap0(fieldValue));
            }
        });
        convertInfoMap.values().stream().filter(o -> Objects.nonNull(o.getTranslate())).forEach(o -> this.translationToMap0((ConvertInfo)o, object, map));
        return map;
    }

    private void translationToMap0(ConvertInfo convertInfo, Object convertObject, Map<String, Object> map) {
        Object dictValue;
        Object fieldValue;
        Translate translate = convertInfo.getTranslate();
        if (StrUtil.isAllEmpty((CharSequence[])new CharSequence[]{translate.source(), translate.target()}) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)convertInfo.getName()))) {
            dictValue = this.getTranslationValue(translate, fieldValue);
            map.put(convertInfo.getName(), dictValue);
        }
        if (StrUtil.isNotBlank((CharSequence)translate.source()) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)translate.source()))) {
            dictValue = this.getTranslationValue(translate, fieldValue);
            map.put(convertInfo.getName(), dictValue);
        }
        if (StrUtil.isNotBlank((CharSequence)translate.target()) && !Objects.isNull(fieldValue = BeanUtil.getProperty((Object)convertObject, (String)convertInfo.getName()))) {
            dictValue = this.getTranslationValue(translate, fieldValue);
            map.put(translate.target(), dictValue);
        }
    }

    private Object getTranslationValue(Translate translate, Object fieldValue) {
        if (fieldValue instanceof Collection) {
            return ((Collection)fieldValue).stream().map(o -> this.getTranslationValue(translate, o)).collect(this.getCollectorType(fieldValue));
        }
        switch (translate.type()) {
            case DICT: {
                return this.getDictValue(translate, fieldValue.toString());
            }
            case TABLE: {
                return this.getTableValue(translate, fieldValue);
            }
        }
        return null;
    }

    private String getDictValue(Translate translate, String fieldValue) {
        TranslationCacheLocal.Cache cache = TranslationCacheLocal.get();
        String dicCode = translate.dicCode();
        return cache.getDictValue(dicCode, fieldValue);
    }

    private Object getTableValue(Translate translate, Object fieldValue) {
        TranslationCacheLocal.Cache cache = TranslationCacheLocal.get();
        return "cache.getTableValue()";
    }

    private void setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        try {
            BeanUtil.setProperty((Object)bean, (String)fieldNameOrIndex, (Object)value);
        }
        catch (Exception e) {
            LogUtils.warn((String)"\u7c7b {} \u7684 \u5b57\u6bb5\u540d\u79f0\u6216\u4e0b\u6807: {}\uff0c\u8d4b\u503c\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u503c\u7c7b\u578b\u4e0e\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[]{bean.getClass().getName(), fieldNameOrIndex});
        }
    }

    private Collector<Object, ?, ?> getCollectorType(Object fieldValue) {
        if (fieldValue instanceof Set) {
            return Collectors.toSet();
        }
        return Collectors.toList();
    }
}

