/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.useragent.configuration;

import com.blueconic.browscap.BrowsCapField;
import com.blueconic.browscap.ParseException;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.UserAgentService;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.useragent.browscap.BrowscapUserAgentConverter;
import com.taotao.boot.useragent.configuration.UserAgentConfiguration;
import com.taotao.boot.useragent.properties.UserAgentProperties;
import com.taotao.boot.useragent.yauaa.YauaaUserAgentConverter;
import java.io.IOException;
import java.util.Arrays;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

@EnableConfigurationProperties(value={UserAgentProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.useragent", name={"enabled"}, havingValue="true")
@AutoConfiguration(before={UserAgentConfiguration.class})
@ImportAutoConfiguration(value={UserAgentConfiguration.class})
public class UserAgentAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(UserAgentAutoConfiguration.class, (String)"taotao-boot-starter-useragent", (String[])new String[0]);
    }

    @AutoConfiguration
    @ConditionalOnClass(value={UserAgentAnalyzer.class})
    public static class YauaaAutoConfiguration {
        @Bean
        @Scope(value="prototype")
        public UserAgentAnalyzer userAgentAnalyzer() {
            return (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000)).build();
        }

        @Bean
        @ConditionalOnMissingBean
        public YauaaUserAgentConverter yauaaUserAgentConverter(UserAgentAnalyzer userAgentAnalyzer) {
            return new YauaaUserAgentConverter(userAgentAnalyzer);
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={UserAgentParser.class})
    public static class BrowscapAutoConfiguration {
        @Bean
        public UserAgentParser userAgentParser() throws IOException, ParseException {
            return new UserAgentService().loadParser(Arrays.asList(BrowsCapField.values()));
        }

        @Bean
        @ConditionalOnMissingBean
        public BrowscapUserAgentConverter browscapUserAgentConverter(UserAgentParser userAgentAnalyzer) {
            return new BrowscapUserAgentConverter(userAgentAnalyzer);
        }
    }
}

