/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.useragent.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.useragent.reactive.ReactiveUserAgentFilter;
import com.taotao.boot.useragent.reactive.ReactiveUserAgentResolver;
import com.taotao.boot.useragent.servlet.UserAgentFilter;
import com.taotao.boot.useragent.servlet.UserAgentResolver;
import com.taotao.boot.useragent.support.UserAgentConverter;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnBean(value={UserAgentConverter.class})
@ConditionalOnProperty(prefix="taotao.boot.useragent", name={"enabled"}, havingValue="true")
public class UserAgentConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(UserAgentConfiguration.class, (String)"taotao-boot-starter-useragent", (String[])new String[0]);
    }

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class UserAgentReactiveAutoConfiguration
    implements WebFluxConfigurer {
        @Bean
        public ReactiveUserAgentFilter reactiveUserAgentFilter() {
            return new ReactiveUserAgentFilter();
        }

        public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
            configurer.addCustomResolver(new org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver[]{new ReactiveUserAgentResolver()});
        }
    }

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class UserAgentMvcAutoConfiguration
    implements WebMvcConfigurer {
        @Bean
        public FilterRegistrationBean<UserAgentFilter> filterRegistrationBean() {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)new UserAgentFilter());
            registrationBean.addUrlPatterns(new String[]{"/*"});
            registrationBean.setName("userAgentFilter");
            registrationBean.setOrder(1);
            return registrationBean;
        }

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
            resolvers.add(new UserAgentResolver());
        }
    }
}

