/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.useragent.servlet;

import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.useragent.annotation.UserAgentInfo;
import com.taotao.boot.useragent.domain.UserAgent;
import com.taotao.boot.useragent.helper.UserAgentHelper;
import com.taotao.boot.useragent.servlet.UserAgentContextHolder;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class UserAgentResolver
implements HandlerMethodArgumentResolver {
    public final boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(UserAgentInfo.class);
    }

    public final Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        UserAgent agentContext = UserAgentContextHolder.getUserAgentContext();
        if (agentContext == null) {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Assert.notNull((Object)request, (String)"request not be null!");
            HttpHeaders headers = RequestUtils.headers((HttpServletRequest)request);
            agentContext = UserAgentHelper.convert(headers);
            UserAgentContextHolder.setUserAgentContext(agentContext);
        }
        return agentContext;
    }
}

