/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.aop.aop.feign;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.taotao.boot.web.aop.aop.feign.Constants;
import com.taotao.boot.web.aop.aop.feign.RemoteServiceException;
import com.taotao.boot.web.aop.aop.feign.ThrowableDTO;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
public class RemoteServiceErrorDecoder
implements ErrorDecoder,
Constants {
    private ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();

    public Exception decode(String methodKey, Response response) {
        if (response.status() == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            try {
                String message = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
                JSONObject jsonObject = JSON.parseObject((String)message);
                if (jsonObject != null && jsonObject.getBooleanValue("hasJoshuaRemoteError")) {
                    ThrowableDTO throwableDTO = (ThrowableDTO)jsonObject.getObject("joshuaRemoteErrorThrowableInstance", ThrowableDTO.class, new JSONReader.Feature[0]);
                    return new RemoteServiceException("Caught remote service [" + methodKey + "] exception", throwableDTO.toThrowable());
                }
            }
            catch (IOException e) {
                return e;
            }
        }
        return this.defaultErrorDecoder.decode(methodKey, response);
    }
}

