/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.aop.aop.feign;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;

public class ThrowableDTO {
    private String className;
    private String message;
    private StackTraceElementDTO[] stackTraceElements;
    private ThrowableDTO[] suppressed;
    private ThrowableDTO cause;

    public ThrowableDTO() {
    }

    public ThrowableDTO(Throwable e) {
        this.className = e.getClass().getName();
        this.message = e.getMessage();
        this.stackTraceElements = (StackTraceElementDTO[])Arrays.stream(e.getStackTrace()).map(StackTraceElementDTO::new).toArray(StackTraceElementDTO[]::new);
        if (e.getSuppressed() != null) {
            this.suppressed = (ThrowableDTO[])Arrays.stream(e.getSuppressed()).filter(Objects::nonNull).filter(x -> x != e).map(ThrowableDTO::new).toArray(ThrowableDTO[]::new);
        }
        if (e.getCause() != null && e.getCause() != e) {
            this.cause = new ThrowableDTO(e.getCause());
        }
    }

    private StackTraceElement[] toStackTrace() {
        return (StackTraceElement[])Arrays.stream(this.stackTraceElements).map(StackTraceElementDTO::toStackTraceElement).toArray(StackTraceElement[]::new);
    }

    public Throwable toThrowable() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Throwable t = null;
        if (clazz != null) {
            Constructor<?> constructor2;
            try {
                constructor2 = clazz.getConstructor(String.class, Throwable.class);
                t = this.cause != null && this.cause != this ? (Throwable)constructor2.newInstance(this.message, this.cause.toThrowable()) : (Throwable)constructor2.newInstance(this.message, null);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constructor2) {
                // empty catch block
            }
            if (t == null && this.message != null && (this.cause == null || this.cause == this)) {
                try {
                    constructor2 = clazz.getConstructor(String.class);
                    t = (Throwable)constructor2.newInstance(this.message);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constructor3) {
                    // empty catch block
                }
            }
            if (t == null && this.message == null && this.cause != null && this.cause != this) {
                try {
                    constructor2 = clazz.getConstructor(Throwable.class);
                    t = (Throwable)constructor2.newInstance(this.cause.toThrowable());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constructor4) {
                    // empty catch block
                }
            }
            if (t == null) {
                try {
                    constructor2 = clazz.getConstructor(new Class[0]);
                    t = (Throwable)constructor2.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        if (t == null) {
            t = new RuntimeException(this.message, this.cause != null && this.cause != this ? this.cause.toThrowable() : null);
        }
        t.setStackTrace(this.toStackTrace());
        if (this.suppressed != null) {
            Arrays.stream(this.suppressed).filter(Objects::nonNull).filter(x -> x != this).map(ThrowableDTO::toThrowable).forEach(t::addSuppressed);
        }
        return t;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStackTraceElements(StackTraceElementDTO[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    public ThrowableDTO[] getSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(ThrowableDTO[] suppressed) {
        this.suppressed = suppressed;
    }

    public ThrowableDTO getCause() {
        return this.cause;
    }

    public void setCause(ThrowableDTO cause) {
        this.cause = cause;
    }

    public static class StackTraceElementDTO {
        private String declaringClass;
        private String methodName;
        private String fileName;
        private int lineNumber;

        public StackTraceElementDTO() {
        }

        public StackTraceElementDTO(StackTraceElement stackTraceElement) {
            this.declaringClass = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName();
            this.fileName = stackTraceElement.getFileName();
            this.lineNumber = stackTraceElement.getLineNumber();
        }

        public StackTraceElement toStackTraceElement() {
            return new StackTraceElement(this.declaringClass, this.methodName, this.fileName, this.lineNumber);
        }

        public String getDeclaringClass() {
            return this.declaringClass;
        }

        public void setDeclaringClass(String declaringClass) {
            this.declaringClass = declaringClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }
    }
}

