/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.configuration;

import com.taotao.boot.common.model.Result;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.servlet.ResponseUtils;
import com.taotao.boot.web.annotation.BusinessApi;
import com.taotao.boot.web.annotation.IgnoreResponseBodyAdvice;
import jakarta.servlet.Servlet;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@AutoConfiguration
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@RestControllerAdvice(annotations={BusinessApi.class})
public class ResponseAutoConfiguration
implements ResponseBodyAdvice<Object>,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ResponseAutoConfiguration.class, (String)"taotao-boot-starter-web", (String[])new String[0]);
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        if (methodParameter.getDeclaringClass().isAnnotationPresent(IgnoreResponseBodyAdvice.class)) {
            return false;
        }
        return !methodParameter.getMethod().isAnnotationPresent(IgnoreResponseBodyAdvice.class);
    }

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        ResponseUtils.addResponseHeader((ServerHttpResponse)serverHttpResponse);
        if (o == null) {
            return null;
        }
        if (o instanceof Result) {
            return o;
        }
        return Result.success((Object)o);
    }
}

