/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.web.properties.FilterProperties;
import com.taotao.boot.web.servlet.filter.TenantFilter;
import com.taotao.boot.web.servlet.filter.TraceFilter;
import com.taotao.boot.web.servlet.filter.VersionFilter;
import com.taotao.boot.web.servlet.filter.WebContextFilter;
import com.taotao.boot.web.servlet.listener.TtcServletContextListener;
import com.taotao.boot.web.servlet.servlet.TtcAsyncServlet;
import com.taotao.boot.web.servlet.servlet.TtcServlet;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.EventListener;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@AutoConfiguration
public class ServletAutoConfiguration
implements WebApplicationInitializer,
InitializingBean {
    private final FilterProperties filterProperties;

    public ServletAutoConfiguration(FilterProperties filterProperties) {
        this.filterProperties = filterProperties;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ServletAutoConfiguration.class, (String)"taotao-boot-starter-web", (String[])new String[0]);
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        LogUtils.info((String)"servletContext.getServerInfo=== {}", (Object[])new Object[]{servletContext.getServerInfo()});
    }

    @Bean
    public ServletRegistrationBean<TtcServlet> ttcServletRegistrationBean() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new TtcServlet());
        servletRegistrationBean.setLoadOnStartup(1);
        servletRegistrationBean.setAsyncSupported(true);
        servletRegistrationBean.setUrlMappings(List.of("/ttcServlet"));
        LogUtils.info((String)"\u6ce8\u518cttcServlet\u6210\u529f\uff0c\u540d\u79f0: {}", (Object[])new Object[]{TtcServlet.class.getName()});
        return servletRegistrationBean;
    }

    @Bean
    public ServletRegistrationBean<TtcAsyncServlet> ttcAsyncServletRegistrationBean() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new TtcAsyncServlet());
        servletRegistrationBean.setLoadOnStartup(1);
        servletRegistrationBean.setAsyncSupported(true);
        servletRegistrationBean.setUrlMappings(List.of("/ttcAsyncServlet"));
        LogUtils.info((String)"\u6ce8\u518cttcAsyncServlet\u6210\u529f\uff0c\u540d\u79f0: {}", (Object[])new Object[]{TtcAsyncServlet.class.getName()});
        return servletRegistrationBean;
    }

    @Bean
    public ServletListenerRegistrationBean<TtcServletContextListener> ttcServletListenerRegistrationBean() {
        ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean();
        bean.setListener((EventListener)((Object)new TtcServletContextListener()));
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.web.filter", name={"version"}, havingValue="true")
    public FilterRegistrationBean<VersionFilter> versionFilterFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new VersionFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(VersionFilter.class.getName());
        registrationBean.setOrder(-2147483642);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.web.filter", name={"tenant"}, havingValue="true")
    public FilterRegistrationBean<TenantFilter> tenantFilterFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TenantFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(TenantFilter.class.getName());
        registrationBean.setOrder(-2147483643);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<TraceFilter> traceFilterFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TraceFilter(this.filterProperties));
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(TraceFilter.class.getName());
        registrationBean.setOrder(-2147483644);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.web.filter", name={"webContext"}, havingValue="true")
    public FilterRegistrationBean<WebContextFilter> webContextFilterFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new WebContextFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName(WebContextFilter.class.getName());
        registrationBean.setOrder(-2147483645);
        return registrationBean;
    }

    @Bean
    public CommonsRequestLoggingFilter commonsRequestLoggingFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludePayload(true);
        filter.setIncludeHeaders(true);
        filter.setIncludeClientInfo(true);
        filter.setAfterMessagePrefix("REQUEST DATA: ");
        return filter;
    }
}

