/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.IOException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@AutoConfiguration(before={ServletWebServerFactoryAutoConfiguration.class})
@ConditionalOnClass(value={Undertow.class})
public class UndertowHttp2AutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(UndertowHttp2AutoConfiguration.class, (String)"taotao-boot-starter-web", (String[])new String[0]);
    }

    @Bean
    public UndertowServerFactoryCustomizer undertowServerFactoryCustomizer() {
        LogUtils.started(UndertowServerFactoryCustomizer.class, (String)"taotao-boot-starter-web", (String[])new String[0]);
        return new UndertowServerFactoryCustomizer();
    }

    public static class UndertowServerFactoryCustomizer
    implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
        public void customize(UndertowServletWebServerFactory factory) {
            UndertowDeploymentInfoCustomizer undertowDeploymentInfoCustomizer = deploymentInfo -> {
                WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)deploymentInfo.getServletContextAttributes().get("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
                XnioWorker worker = this.getXnioWorker();
                DefaultByteBufferPool buffers = new DefaultByteBufferPool(Boolean.getBoolean("io.undertow.websockets.direct-buffers"), 1024, 100, 12);
                info.setWorker(worker);
                info.setBuffers((ByteBufferPool)buffers);
            };
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{undertowDeploymentInfoCustomizer});
            factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true)});
        }

        private XnioWorker getXnioWorker() {
            XnioWorker worker = null;
            try {
                worker = Xnio.getInstance().createWorker(OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return worker;
        }
    }
}

