/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.controller;

import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import java.util.Map;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;

public class CustomErrorAttributes
extends DefaultErrorAttributes {
    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions options) {
        String requestUrl = (String)this.getAttr(webRequest, "jakarta.servlet.error.request_uri");
        if (StringUtils.isBlank((String)requestUrl)) {
            requestUrl = (String)this.getAttr(webRequest, "jakarta.servlet.forward.request_uri");
        }
        Integer status = (Integer)this.getAttr(webRequest, "jakarta.servlet.error.status_code");
        Throwable error = this.getError(webRequest);
        LogUtils.error((String)"URL:{} error status:{}", (Object[])new Object[]{requestUrl, status, error});
        return super.getErrorAttributes(webRequest, options);
    }

    @Nullable
    private <T> T getAttr(WebRequest webRequest, String name) {
        return (T)webRequest.getAttribute(name, 0);
    }
}

