/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taotao.boot.common.enums.ResultEnum;
import com.taotao.boot.common.model.Result;
import com.taotao.boot.common.utils.common.JsonUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class CustomErrorController
extends BasicErrorController {
    private final ObjectMapper objectMapper;

    public CustomErrorController(ObjectMapper objectMapper, ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        super(errorAttributes, errorProperties);
        this.objectMapper = objectMapper;
    }

    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        Result fail = Result.fail((ResultEnum)ResultEnum.REQUEST_NOT_FOUND);
        Map map = JsonUtils.toMap((Object)fail);
        return new ResponseEntity((Object)map, HttpStatusCode.valueOf((int)200));
    }

    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        Map body = this.getErrorAttributes(request, ErrorAttributeOptions.defaults());
        HttpStatus status = this.getStatus(request);
        response.setStatus(status.value());
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setObjectMapper(this.objectMapper);
        view.setContentType("application/json");
        return new ModelAndView((View)view, body);
    }
}

