/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.exception.configuration;

import com.taotao.boot.web.exception.advice.BusinessHandlerExceptionAdvice;
import com.taotao.boot.web.exception.advice.FeignHandlerExceptionAdvice;
import com.taotao.boot.web.exception.configuration.DingTalkExceptionHandlerAutoConfiguration;
import com.taotao.boot.web.exception.configuration.LoggerExceptionHandlerAutoConfiguration;
import com.taotao.boot.web.exception.configuration.MailExceptionHandlerAutoConfiguration;
import com.taotao.boot.web.exception.handler.ExceptionHandler;
import com.taotao.boot.web.exception.properties.ExceptionHandleProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@AutoConfiguration(after={DingTalkExceptionHandlerAutoConfiguration.class, LoggerExceptionHandlerAutoConfiguration.class, MailExceptionHandlerAutoConfiguration.class})
@ConditionalOnProperty(prefix="taotao.boot.web.global-exception", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ExceptionHandleProperties.class})
public class ExceptionAutoConfiguration {
    @Bean
    public BusinessHandlerExceptionAdvice businessHandlerExceptionAdvice(List<ExceptionHandler> exceptionHandlers) {
        return new BusinessHandlerExceptionAdvice(exceptionHandlers);
    }

    @Bean
    public FeignHandlerExceptionAdvice feignHandlerExceptionAdvice(List<ExceptionHandler> exceptionHandlers, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="asyncThreadPoolTaskExecutor") ThreadPoolTaskExecutor asyncThreadPoolTaskExecutor) {
        return new FeignHandlerExceptionAdvice(exceptionHandlers, asyncThreadPoolTaskExecutor, applicationEventPublisher);
    }
}

