/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.mvc.interceptor;

import com.taotao.boot.common.utils.servlet.TraceUtils;
import io.micrometer.tracing.Tracer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class TraceMdcInterceptor
implements HandlerInterceptor {
    @Autowired
    private Tracer tracer;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceIdByRequest = TraceUtils.getTraceIdByRequest((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)traceIdByRequest)) {
            traceIdByRequest = Objects.requireNonNull(this.tracer.currentTraceContext().context()).traceId();
        }
        TraceUtils.setTraceId((String)traceIdByRequest);
        String spanIdByRequest = TraceUtils.getSpanIdByRequest((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)spanIdByRequest)) {
            spanIdByRequest = Objects.requireNonNull(this.tracer.currentTraceContext().context()).spanId();
        }
        TraceUtils.setSpanId((String)spanIdByRequest);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TraceUtils.removeTraceId();
        TraceUtils.removeSpanId();
    }
}

