/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.mvc.resolver;

import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.security.spring.core.userdetails.TtcUser;
import com.taotao.boot.security.spring.utils.SecurityUtils;
import com.taotao.boot.web.annotation.LoginUser;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class LoginUserArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        boolean isHasEnableUserAnn = parameter.hasParameterAnnotation(LoginUser.class);
        boolean isHasLoginUserParameter = parameter.getParameterType().isAssignableFrom(BaseSecurityUser.class);
        return isHasEnableUserAnn && isHasLoginUserParameter;
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        LoginUser user = (LoginUser)methodParameter.getParameterAnnotation(LoginUser.class);
        boolean value = user.value();
        HttpServletRequest request = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        TtcUser loginUser = SecurityUtils.getCurrentUser();
        return loginUser;
    }
}

