/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.request.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.web.request.enums.RequestLoggerTypeEnum;
import com.taotao.boot.web.request.properties.RequestLoggerProperties;
import com.taotao.boot.web.request.service.IRequestLoggerService;
import com.taotao.boot.web.request.service.impl.LoggerRequestLoggerServiceImpl;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.boot.web.request", name={"enabled"}, havingValue="true")
public class LoggerRequestLoggerConfiguration
implements InitializingBean {
    @Autowired
    private RequestLoggerProperties requestLoggerProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(LoggerRequestLoggerConfiguration.class, (String)"taotao-boot-starter-logger", (String[])new String[0]);
    }

    @Bean
    public IRequestLoggerService loggerRequestLoggerService() {
        if (Arrays.stream(this.requestLoggerProperties.getTypes()).anyMatch(e -> e.name().equals(RequestLoggerTypeEnum.LOGGER.name()))) {
            return new LoggerRequestLoggerServiceImpl();
        }
        return null;
    }
}

