/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.request.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.web.request.aspect.RequestLoggerAspect;
import com.taotao.boot.web.request.configuration.KafkaRequestLoggerConfiguration;
import com.taotao.boot.web.request.configuration.LoggerRequestLoggerConfiguration;
import com.taotao.boot.web.request.configuration.RedisRequestLoggerConfiguration;
import com.taotao.boot.web.request.listener.RequestLoggerListener;
import com.taotao.boot.web.request.properties.RequestLoggerProperties;
import com.taotao.boot.web.request.service.IRequestLoggerService;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RedisRequestLoggerConfiguration.class, KafkaRequestLoggerConfiguration.class, LoggerRequestLoggerConfiguration.class})
@EnableConfigurationProperties(value={RequestLoggerProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.web.request", name={"enabled"}, havingValue="true")
public class RequestLoggerConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RequestLoggerConfiguration.class, (String)"taotao-boot-starter-logger", (String[])new String[0]);
    }

    @Bean
    public RequestLoggerListener requestLoggerListener(List<IRequestLoggerService> requestLoggerServices) {
        return new RequestLoggerListener(requestLoggerServices);
    }

    @Bean
    public RequestLoggerAspect requestLoggerAspect() {
        return new RequestLoggerAspect();
    }
}

