/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.request.listener;

import com.taotao.boot.web.request.event.RequestLoggerEvent;
import com.taotao.boot.web.request.model.RequestLog;
import com.taotao.boot.web.request.service.IRequestLoggerService;
import java.util.List;
import java.util.Objects;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class RequestLoggerListener {
    private final List<IRequestLoggerService> requestLoggerService;

    public RequestLoggerListener(List<IRequestLoggerService> requestLoggerServices) {
        this.requestLoggerService = requestLoggerServices;
    }

    @Async
    @EventListener(value={RequestLoggerEvent.class})
    public void saveRequestLog(RequestLoggerEvent event) {
        RequestLog requestLog = (RequestLog)event.getSource();
        if (Objects.nonNull(this.requestLoggerService) && !this.requestLoggerService.isEmpty()) {
            this.requestLoggerService.stream().filter(Objects::nonNull).forEach(service -> service.save(requestLog));
        }
    }
}

