/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.servlet.filter;

import com.taotao.boot.common.holder.TenantContextHolder;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.common.utils.servlet.ResponseUtils;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.web.filter.OncePerRequestFilter;

public class TenantFilter
extends OncePerRequestFilter {
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return RequestUtils.excludeActuator((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            String tenantId = request.getParameter("ttc-tenant-id");
            if (StrUtil.isEmpty((CharSequence)tenantId)) {
                tenantId = request.getHeader("ttc-tenant-id");
            }
            if (StringUtils.isNotBlank((String)tenantId)) {
                TenantContextHolder.setTenant((String)tenantId);
                TraceUtils.setTtcTenantId((String)tenantId);
            } else if (StringUtils.isBlank((String)TenantContextHolder.getTenant())) {
                TenantContextHolder.setTenant((String)"1");
                TraceUtils.setTtcTenantId((String)"1");
            }
            ResponseUtils.addResponseHeader((HttpServletResponse)response, (String)"ttc-tenant-id", (String)TenantContextHolder.getTenant());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            TenantContextHolder.clear();
            TraceUtils.removeTtcTenantId();
        }
    }
}

