/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.servlet.filter;

import com.taotao.boot.common.holder.TraceContextHolder;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.common.utils.servlet.ResponseUtils;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import com.taotao.boot.web.properties.FilterProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.web.filter.OncePerRequestFilter;

public class TraceFilter
extends OncePerRequestFilter {
    private final FilterProperties filterProperties;

    public TraceFilter(FilterProperties filterProperties) {
        this.filterProperties = filterProperties;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return RequestUtils.excludeActuator((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String traceId = TraceUtils.getTtcTraceIdByRequest((HttpServletRequest)request);
            if (StringUtils.isBlank((String)traceId)) {
                traceId = IdGeneratorUtils.getIdStr();
            }
            TraceContextHolder.setTraceId((String)traceId);
            TraceUtils.setTtcTraceId((String)traceId);
            TraceUtils.setZipkinTraceId((HttpServletRequest)request);
            TraceUtils.setZipkinSpanId((HttpServletRequest)request);
            ResponseUtils.addResponseHeader((HttpServletResponse)response, (String)"ttc-trace-id", (String)TraceContextHolder.getTraceId());
            ResponseUtils.addResponseHeader((HttpServletResponse)response, (String)"X-B3-TraceId", (String)TraceUtils.getZipkinTraceId());
            ResponseUtils.addResponseHeader((HttpServletResponse)response, (String)"X-B3-SpanId", (String)TraceUtils.getZipkinSpanId());
            ResponseUtils.addResponseHeader((HttpServletResponse)response, (String)"tid", (String)TraceContext.traceId());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            TraceContextHolder.clear();
            TraceUtils.removeTtcTraceId();
            TraceUtils.removeZipkinTraceId();
            TraceUtils.removeZipkinSpanId();
        }
    }
}

