/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.servlet.filter;

import com.taotao.boot.common.holder.VersionContextHolder;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.common.utils.servlet.ResponseUtils;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.web.filter.OncePerRequestFilter;

public class VersionFilter
extends OncePerRequestFilter {
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return RequestUtils.excludeActuator((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            String version = request.getHeader("ttc-request-version");
            if (StrUtil.isNotEmpty((CharSequence)version)) {
                VersionContextHolder.setVersion((String)version);
                TraceUtils.setTtcVersion((String)version);
            }
            ResponseUtils.addResponseHeader((HttpServletResponse)response, (String)"ttc-request-version", (String)VersionContextHolder.getVersion());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            VersionContextHolder.clear();
            TraceUtils.removeTtcVersion();
        }
    }
}

