/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.support.encryption.core.bs;

import com.taotao.boot.common.support.hash.HashBs;
import com.taotao.boot.common.support.hash.api.IHash;
import com.taotao.boot.common.support.hash.core.Hashes;
import com.taotao.boot.common.support.secret.api.ISecret;
import com.taotao.boot.common.support.secret.core.SecretBs;
import com.taotao.boot.common.support.secret.core.secret.Secrets;
import com.taotao.boot.common.utils.common.ArgUtils;
import com.taotao.boot.web.support.encryption.api.core.IEncryptMask;
import com.taotao.boot.web.support.encryption.api.core.IEncryptMaskFactory;
import com.taotao.boot.web.support.encryption.api.core.IEncryption;
import com.taotao.boot.web.support.encryption.api.core.IEncryptionContext;
import com.taotao.boot.web.support.encryption.api.core.IEncryptionFactory;
import com.taotao.boot.web.support.encryption.api.dto.req.CommonDecryptRequest;
import com.taotao.boot.web.support.encryption.api.dto.req.CommonEncryptRequest;
import com.taotao.boot.web.support.encryption.api.dto.resp.CommonEncryptResponse;
import com.taotao.boot.web.support.encryption.core.core.DefaultEncryptionFactory;
import com.taotao.boot.web.support.encryption.core.core.EncryptionContext;
import com.taotao.boot.web.support.encryption.core.support.mask.DefaultEncryptMaskFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class EncryptionLocalBs {
    private Charset charset = StandardCharsets.UTF_8;
    private String salt = "99886622";
    private IHash hash = Hashes.md5();
    private ISecret secret = Secrets.aes();
    private IEncryptMaskFactory maskFactory = new DefaultEncryptMaskFactory();
    private IEncryptionFactory encryptionFactory = new DefaultEncryptionFactory();
    private IEncryptionContext encryptionContext;

    private EncryptionLocalBs() {
    }

    public static EncryptionLocalBs newInstance() {
        return new EncryptionLocalBs();
    }

    public EncryptionLocalBs charset(Charset charset) {
        ArgUtils.notNull((Object)charset, (String)"charset");
        this.charset = charset;
        return this;
    }

    public EncryptionLocalBs salt(String salt) {
        ArgUtils.notEmpty((String)salt, (String)"salt");
        this.salt = salt;
        return this;
    }

    public EncryptionLocalBs hash(IHash hash) {
        ArgUtils.notNull((Object)hash, (String)"hash");
        this.hash = hash;
        return this;
    }

    public EncryptionLocalBs secret(ISecret secret) {
        ArgUtils.notNull((Object)secret, (String)"secret");
        this.secret = secret;
        return this;
    }

    public EncryptionLocalBs maskFactory(IEncryptMaskFactory maskFactory) {
        ArgUtils.notNull((Object)maskFactory, (String)"maskFactory");
        this.maskFactory = maskFactory;
        return this;
    }

    public EncryptionLocalBs encryptionFactory(IEncryptionFactory encryptionFactory) {
        ArgUtils.notNull((Object)encryptionFactory, (String)"encryptionFactory");
        this.encryptionFactory = encryptionFactory;
        return this;
    }

    public synchronized EncryptionLocalBs init() {
        ArgUtils.notEmpty((String)this.salt, (String)"salt");
        byte[] salts = this.salt.getBytes(this.charset);
        HashBs hashBs = HashBs.newInstance().charset(this.charset).hash(this.hash).salt(salts);
        SecretBs secretBs = SecretBs.newInstance().charset(this.charset.name()).secret(this.secret).key(salts);
        this.encryptionContext = EncryptionContext.newInstance().hashBs(hashBs).secretBs(secretBs);
        return this;
    }

    public CommonEncryptResponse encrypt(String plainText, String type) {
        this.checkStatus();
        IEncryptMask encryptMask = this.maskFactory.get(type);
        IEncryption encryption = this.encryptionFactory.get(type);
        CommonEncryptRequest request = new CommonEncryptRequest();
        request.setText(plainText);
        request.setEncryptMask(encryptMask);
        return encryption.encrypt(request, this.encryptionContext);
    }

    public String decrypt(String cipher, String type) {
        this.checkStatus();
        IEncryption encryption = this.encryptionFactory.get(type);
        CommonDecryptRequest request = new CommonDecryptRequest();
        request.setCipher(cipher);
        return encryption.decrypt(request, this.encryptionContext).getText();
    }

    public String hash(String plainText) {
        this.checkStatus();
        return this.encryptionContext.hashBs().execute(plainText);
    }

    private void checkStatus() {
        if (this.encryptionContext == null) {
            this.init();
        }
    }
}

