/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.support.encryption.core.core;

import com.taotao.boot.common.support.secret.core.HexUtil;
import com.taotao.boot.common.support.secret.core.SecretBs;
import com.taotao.boot.web.support.encryption.api.core.EncryptMaskContext;
import com.taotao.boot.web.support.encryption.api.core.IEncryptMask;
import com.taotao.boot.web.support.encryption.api.core.IEncryption;
import com.taotao.boot.web.support.encryption.api.core.IEncryptionContext;
import com.taotao.boot.web.support.encryption.api.dto.req.CommonDecryptRequest;
import com.taotao.boot.web.support.encryption.api.dto.req.CommonEncryptRequest;
import com.taotao.boot.web.support.encryption.api.dto.resp.CommonDecryptResponse;
import com.taotao.boot.web.support.encryption.api.dto.resp.CommonEncryptResponse;

public class CommonEncryption
implements IEncryption {
    protected String getMask(CommonEncryptRequest request) {
        EncryptMaskContext context = new EncryptMaskContext();
        context.setPlainText(request.getText());
        IEncryptMask encryptMask = request.getEncryptMask();
        return encryptMask.mask(context);
    }

    @Override
    public CommonEncryptResponse encrypt(CommonEncryptRequest request, IEncryptionContext context) {
        String plain = request.getText();
        String cipher = context.secretBs().encryptToHexString(plain);
        String hash = context.hashBs().execute(plain);
        String mask = this.getMask(request);
        CommonEncryptResponse response = new CommonEncryptResponse();
        response.setMask(mask);
        response.setCipher(cipher);
        response.setHash(hash);
        return response;
    }

    @Override
    public CommonDecryptResponse decrypt(CommonDecryptRequest request, IEncryptionContext context) {
        SecretBs secretBs = context.secretBs();
        byte[] bytes = HexUtil.hexStringToByte((String)request.getCipher());
        String plain = secretBs.decryptToString(bytes);
        CommonDecryptResponse response = new CommonDecryptResponse();
        response.setText(plain);
        return response;
    }
}

