/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.support.enums.mvc.message;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.taotao.boot.common.enums.base.CommonEnum;
import com.taotao.boot.web.support.enums.mvc.CommonEnumRegistry;
import com.taotao.boot.web.support.enums.mvc.CommonEnumVO;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CommonEnumJacksonCustomizer {
    @Autowired
    private CommonEnumRegistry enumRegistry;

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer commonEnumBuilderCustomizer() {
        return builder -> {
            Map<Class<?>, List<CommonEnum>> classDict = this.enumRegistry.getClassDict();
            classDict.forEach((aClass, commonEnums) -> {
                builder.deserializerByType(aClass, (JsonDeserializer)new CommonEnumJsonDeserializer((List<CommonEnum>)commonEnums));
                builder.serializerByType(aClass, (JsonSerializer)new CommonEnumJsonSerializer());
            });
        };
    }

    static class CommonEnumJsonDeserializer
    extends JsonDeserializer<CommonEnum> {
        private final List<CommonEnum> commonEnums;

        CommonEnumJsonDeserializer(List<CommonEnum> commonEnums) {
            this.commonEnums = commonEnums;
        }

        public CommonEnum deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            String value = (String)jsonParser.readValueAs(String.class);
            return this.commonEnums.stream().filter(commonEnum -> commonEnum.match(value)).findFirst().orElse(null);
        }
    }

    static class CommonEnumJsonSerializer
    extends JsonSerializer<CommonEnum> {
        CommonEnumJsonSerializer() {
        }

        public void serialize(CommonEnum commonEnum, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            CommonEnumVO commonEnumVO = CommonEnumVO.from(commonEnum);
            jsonGenerator.writeObject((Object)commonEnumVO);
        }
    }
}

