/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.support.version;

import com.taotao.boot.common.exception.ApiVersionDeprecatedException;
import com.taotao.boot.web.annotation.ApiVersion;
import com.taotao.boot.web.support.version.ApiVersionProperties;
import jakarta.servlet.http.HttpServletRequest;
import org.dromara.hutool.core.comparator.CompareUtil;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVersionRequestCondition
implements RequestCondition<ApiVersionRequestCondition> {
    private ApiVersion apiVersion;
    private ApiVersionProperties apiVersionProperties;
    private Integer versionPlaceholderIndex;

    public ApiVersionRequestCondition(ApiVersion apiVersion, ApiVersionProperties apiVersionProperties, Integer versionPlaceholderIndex) {
        this.apiVersion = apiVersion;
        this.apiVersionProperties = apiVersionProperties;
        this.versionPlaceholderIndex = versionPlaceholderIndex;
    }

    public ApiVersionRequestCondition combine(ApiVersionRequestCondition apiVersionRequestCondition) {
        return new ApiVersionRequestCondition(apiVersionRequestCondition.getApiVersion(), apiVersionRequestCondition.getApiVersionProperties(), apiVersionRequestCondition.getVersionPlaceholderIndex());
    }

    public ApiVersionRequestCondition getMatchingCondition(HttpServletRequest request) {
        double apiVersionValue;
        String requestURI = request.getRequestURI();
        String[] versionPaths = SplitUtil.splitToArray((CharSequence)requestURI, (CharSequence)"/");
        double pathVersion = Double.parseDouble(versionPaths[this.versionPlaceholderIndex].substring(1));
        if (pathVersion >= (apiVersionValue = this.getApiVersion().value())) {
            double minimumVersion = this.apiVersionProperties.getMinimumVersion();
            if ((this.getApiVersion().deprecated() || minimumVersion > pathVersion) && NumberUtil.equals((Number)pathVersion, (Number)apiVersionValue)) {
                throw new ApiVersionDeprecatedException(StrUtil.format((CharSequence)"\u5ba2\u6237\u7aef\u8c03\u7528\u5f03\u7528\u7248\u672cAPI\u63a5\u53e3\uff0crequestURI\uff1a{}", (Object[])new Object[]{requestURI}));
            }
            if (this.getApiVersion().deprecated()) {
                return null;
            }
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionRequestCondition apiVersionRequestCondition, HttpServletRequest request) {
        return CompareUtil.compare((double)apiVersionRequestCondition.getApiVersion().value(), (double)this.getApiVersion().value());
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVersionProperties getApiVersionProperties() {
        return this.apiVersionProperties;
    }

    public void setApiVersionProperties(ApiVersionProperties apiVersionProperties) {
        this.apiVersionProperties = apiVersionProperties;
    }

    public Integer getVersionPlaceholderIndex() {
        return this.versionPlaceholderIndex;
    }

    public void setVersionPlaceholderIndex(Integer versionPlaceholderIndex) {
        this.versionPlaceholderIndex = versionPlaceholderIndex;
    }
}

