/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class CollectionUtils {
    public static Collection<? extends Serializable> stringToCollection(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String[] strArray = str.split(",");
        Long[] longs = new Long[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            longs[i] = CollectionUtils.strToLong(strArray[i], 0L);
        }
        return CollectionUtils.arrayToCollection(longs);
    }

    public static Collection<? extends Serializable> arrayToCollection(Long[] longArray) {
        return Arrays.asList(longArray);
    }

    public static long strToLong(@Nullable String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long objectToLong(@Nullable Object str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(String.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }
}

