/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.validation.validator;

import com.taotao.boot.common.utils.date.DateUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.web.validation.annotation.Birthday;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.lang.Validator;

public class BirthdayValidator
implements ConstraintValidator<Birthday, Object> {
    private boolean notNull;

    public void initialize(Birthday constraintAnnotation) {
        this.notNull = constraintAnnotation.notNull();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        String validValue = null;
        if (value instanceof String) {
            validValue = (String)value;
        } else if (value instanceof Date) {
            validValue = DateUtil.formatDate((Date)((Date)value));
        } else if (value instanceof TemporalAccessor) {
            validValue = DateUtils.toDateFormatter((TemporalAccessor)((TemporalAccessor)value));
        }
        if (StringUtils.isNotBlank((String)validValue)) {
            return Validator.isBirthday((CharSequence)validValue);
        }
        return !this.notNull;
    }
}

