/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.web.validation.validator;

import com.taotao.boot.common.enums.CityTypeEnum;
import com.taotao.boot.common.model.CityEntity;
import com.taotao.boot.web.validation.annotation.CheckCityValid;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

public class CheckCityValidator
implements ConstraintValidator<CheckCityValid, String> {
    private CityTypeEnum type;
    @Autowired
    private StringRedisTemplate redisTemplate;

    public void initialize(CheckCityValid annotation) {
        this.type = annotation.value();
    }

    public boolean isValid(String inputValue, ConstraintValidatorContext context) {
        if (inputValue == null) {
            return false;
        }
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)"constant:city");
        if (!StringUtils.hasText((String)jsonStr)) {
            try {
                ClassPathResource resource = new ClassPathResource("city.json");
                InputStream inputStream = resource.getInputStream();
                String line = IoUtil.readUtf8((InputStream)inputStream);
                this.redisTemplate.opsForValue().set((Object)"constant:city", (Object)line);
                jsonStr = line;
            }
            catch (IOException | IORuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        List cityJson = JSONUtil.toList((String)jsonStr, CityEntity.class);
        return (switch (this.type) {
            case CityTypeEnum.PROVINCE -> cityJson.stream().filter(item -> inputValue.equals(item.getName()) && item.getParent() == null).findFirst().orElse(null);
            default -> cityJson.stream().filter(item -> {
                if (inputValue.equals(item.getName()) && item.getParent() != null) {
                    CityEntity parentEntity = cityJson.stream().filter(parent -> item.getParent().equals(parent.getValue()) && parent.getParent() == null).findFirst().orElse(null);
                    return parentEntity != null;
                }
                return false;
            }).findFirst().orElse(null);
            case CityTypeEnum.AREA -> cityJson.stream().filter(item -> {
                if (inputValue.equals(item.getName()) && item.getParent() != null) {
                    CityEntity parentEntity = cityJson.stream().filter(parent -> item.getParent().equals(parent.getValue()) && parent.getParent() != null).findFirst().orElse(null);
                    return parentEntity != null;
                }
                return false;
            }).findFirst().orElse(null);
        }) != null;
    }
}

