/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.webagg.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.taotao.boot.common.enums.ResultEnum;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.model.Result;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.data.mybatis.mybatisplus.query.conditions.Wraps;
import com.taotao.boot.data.mybatis.mybatisplus.query.conditions.query.QueryWrap;
import com.taotao.boot.web.request.annotation.RequestLogger;
import com.taotao.boot.webagg.controller.BaseController;
import com.taotao.boot.webagg.entity.SuperEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;

public interface BaseDeleteController<T extends SuperEntity<T, I>, I extends Serializable>
extends BaseController<T, I> {
    @Operation(summary="\u901a\u7528\u5355\u4f53id\u5220\u9664", description="\u901a\u7528\u5355\u4f53id\u5220\u9664")
    @Parameters(value={@Parameter(name="id", description="id", required=true, example="123", in=ParameterIn.PATH)})
    @DeleteMapping(value={"/{id:[0-9]*}"})
    @RequestLogger(value="\u901a\u7528\u5355\u4f53id\u5220\u9664")
    default public Result<Boolean> deleteById(@NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="id") @NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") I id) {
        if (this.handlerDeleteById(id).booleanValue()) {
            return this.success(this.service().removeById((Serializable)id));
        }
        throw new BusinessException(ResultEnum.ERROR);
    }

    default public Boolean handlerDeleteById(I id) {
        if (Objects.isNull(id)) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }

    @Operation(summary="\u901a\u7528\u5355\u4f53\u5b57\u6bb5\u5220\u9664", description="\u901a\u7528\u5355\u4f53\u5b57\u6bb5\u5220\u9664")
    @Parameters(value={@Parameter(name="filedName", description="\u5b57\u6bb5\u540d\u79f0", required=true, example="123", in=ParameterIn.PATH), @Parameter(name="filedValue", description="\u5b57\u6bb5\u503c", required=true, example="123", in=ParameterIn.PATH)})
    @DeleteMapping(value={"/{filedName}/{filedValue}"})
    @RequestLogger(value="\u901a\u7528\u5355\u4f53\u5b57\u6bb5\u5220\u9664")
    default public Result<Boolean> deleteByFiled(@NotEmpty(message="\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="filedName") @NotEmpty(message="\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String filedName, @NotNull(message="\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable(value="filedValue") @NotNull(message="\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a") Object filedValue) {
        if (this.handlerDeleteByFiled(filedName, filedValue).booleanValue() && ReflectionUtils.checkField((String)filedName, this.getEntityClass()).booleanValue()) {
            QueryWrap wrapper = Wraps.q();
            wrapper.eq(StrUtil.toUnderlineCase((CharSequence)filedName), filedValue);
            return this.success(this.service().remove((Wrapper)wrapper));
        }
        throw new BusinessException(ResultEnum.ERROR);
    }

    default public Boolean handlerDeleteByFiled(String filedName, Object filedValue) {
        if (Objects.isNull(filedName) || Objects.isNull(filedValue)) {
            throw new BusinessException("\u5b57\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return true;
    }
}

