/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.webagg.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.ExcelXorHtmlUtil;
import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.model.BaseQuery;
import com.taotao.boot.common.model.Result;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.query.conditions.query.QueryWrap;
import com.taotao.boot.web.request.annotation.RequestLogger;
import com.taotao.boot.webagg.controller.BasePageController;
import com.taotao.boot.webagg.entity.SuperEntity;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Workbook;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public interface BaseExcelController<T extends SuperEntity<T, I>, I extends Serializable, QueryDTO, QueryVO>
extends BasePageController<T, I, QueryDTO, QueryVO> {
    @Operation(summary="\u901a\u7528\u5bfc\u51faExcel", description="\u901a\u7528\u5bfc\u51faExcel")
    @PostMapping(value={"/excel/export"}, produces={"application/octet-stream"})
    @RequestLogger(value="'\u5bfc\u51faExcel:'.concat([fileName]?:'')")
    default public void export(@Validated @RequestBody QueryDTO params, HttpServletRequest request, HttpServletResponse response) {
        ExportParams exportParams = this.getExportParams(params);
        List<T> list = this.findExportList(params);
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        if (params instanceof BaseQuery) {
            BaseQuery baseQuery = (BaseQuery)params;
            String fileName = baseQuery.execlQuery().fileName();
            map.put("fileName", fileName);
        }
        map.put("data", list);
        map.put("entity", this.getExcelClass());
        map.put("params", exportParams);
    }

    @Operation(summary="\u901a\u7528\u9884\u89c8Excel", description="\u901a\u7528\u9884\u89c8Excel")
    @PostMapping(value={"/excel/preview"})
    @RequestLogger(value="'\u901a\u7528\u9884\u89c8Excel:' + ([fileName]?:'')")
    default public Result<String> preview(@Validated @RequestBody QueryDTO params) {
        ExportParams exportParams = this.getExportParams(params);
        List<T> list = this.findExportList(params);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, this.getExcelClass(), list);
        return this.success(ExcelXorHtmlUtil.excelToHtml((ExcelToHtmlParams)new ExcelToHtmlParams(workbook)));
    }

    @Operation(summary="\u901a\u7528\u5bfc\u5165Excel", description="\u901a\u7528\u5bfc\u5165Excel")
    @Parameters(value={@Parameter(name="file", required=true, description="\u6587\u4ef6\u4fe1\u606f", schema=@Schema(type="file"))})
    @PostMapping(value={"/excel/import"}, headers={"content-type=multipart/form-data"})
    @RequestLogger(value="\u901a\u7528\u5bfc\u5165Excel")
    default public Result<Boolean> importExcel(@NotNull(message="\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") @RequestPart(value="file") @NotNull(message="\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        ImportParams params = new ImportParams();
        params.setTitleRows(StrUtil.isEmpty((CharSequence)request.getParameter("titleRows")) ? 0 : ConvertUtil.toInt((Object)request.getParameter("titleRows")));
        params.setHeadRows(StrUtil.isEmpty((CharSequence)request.getParameter("headRows")) ? 1 : ConvertUtil.toInt((Object)request.getParameter("headRows")));
        try {
            List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), Map.class, (ImportParams)params);
            if (list != null && !list.isEmpty()) {
                return this.success(this.handlerImport(list));
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
        throw new BusinessException("\u5bfc\u5165Excel\u5931\u8d25");
    }

    default public Boolean handlerImport(List<Map<String, String>> list) {
        return true;
    }

    default public ExportParams getExportParams(QueryDTO params) {
        String title = "title";
        String type = "HSSF";
        String sheetName = "sheetName";
        if (params instanceof BaseQuery) {
            BaseQuery baseQuery = (BaseQuery)params;
            if (Objects.isNull(baseQuery.execlQuery())) {
                throw new BusinessException("execl\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            title = baseQuery.execlQuery().title();
            type = baseQuery.execlQuery().type();
            sheetName = baseQuery.execlQuery().sheetName();
        }
        ExcelType excelType = ExcelType.XSSF.name().equals(type) ? ExcelType.XSSF : ExcelType.HSSF;
        ExportParams ep = new ExportParams(title, sheetName, excelType);
        this.enhanceExportParams(ep);
        return ep;
    }

    default public void enhanceExportParams(ExportParams params) {
    }

    default public List<T> findExportList(QueryDTO params) {
        QueryWrap tQueryWrap = this.handlerWrapper(params);
        return this.service().list((Wrapper)tQueryWrap);
    }

    default public Class<T> getExcelClass() {
        return this.getEntityClass();
    }
}

