/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.curator;

import com.taotao.boot.zookeeper.curator.CuratorFactory;
import com.taotao.boot.zookeeper.curator.CuratorFrameworkBuilderCustomizer;
import com.taotao.boot.zookeeper.curator.CuratorProperties;
import com.taotao.boot.zookeeper.curator.support.CuratorTemplate;
import com.taotao.boot.zookeeper.properties.ZookeeperProperties;
import com.taotao.boot.zookeeper.support.ZkIdGenerator;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={CuratorFramework.class})
@EnableConfigurationProperties(value={ZookeeperProperties.class, CuratorProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.zookeeper", name={"enabled"}, havingValue="true")
public class CuratorAutoConfiguration {
    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    public CuratorFramework curatorFramework(CuratorProperties properties, RetryPolicy retryPolicy, ObjectProvider<CuratorFrameworkBuilderCustomizer> curatorFrameworkBuilderCustomizers, ObjectProvider<EnsembleProvider> ensembleProviders, ObjectProvider<TracerDriver> tracerDrivers) throws Exception {
        return CuratorFactory.curatorFramework(properties, retryPolicy, () -> curatorFrameworkBuilderCustomizers.orderedStream(), () -> ensembleProviders.getIfAvailable(), () -> tracerDrivers.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy exponentialBackoffRetry(CuratorProperties properties) {
        return CuratorFactory.retryPolicy(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public CuratorTemplate curatorTemplate(CuratorFramework curatorFramework) {
        return new CuratorTemplate(curatorFramework);
    }

    @Bean
    public ZkIdGenerator zkIdGenerator(CuratorFramework curatorFramework) {
        return new ZkIdGenerator(curatorFramework);
    }
}

