/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.curator;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.zookeeper.curator.CuratorFrameworkBuilderCustomizer;
import com.taotao.boot.zookeeper.curator.CuratorProperties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;

public abstract class CuratorFactory {
    public static CuratorFramework curatorFramework(CuratorProperties properties, RetryPolicy retryPolicy, Supplier<Stream<CuratorFrameworkBuilderCustomizer>> optionalCuratorFrameworkCustomizerProvider, Supplier<EnsembleProvider> optionalEnsembleProvider, Supplier<TracerDriver> optionalTracerDriverProvider) throws Exception {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        EnsembleProvider ensembleProvider = optionalEnsembleProvider.get();
        if (ensembleProvider != null) {
            builder.ensembleProvider(ensembleProvider);
        } else {
            builder.connectString(properties.getConnectString());
        }
        builder.sessionTimeoutMs((int)properties.getSessionTimeout().toMillis()).connectionTimeoutMs((int)properties.getConnectionTimeout().toMillis()).retryPolicy(retryPolicy);
        Stream<CuratorFrameworkBuilderCustomizer> customizers = optionalCuratorFrameworkCustomizerProvider.get();
        if (customizers != null) {
            customizers.forEach(curatorFrameworkCustomizer -> curatorFrameworkCustomizer.customize(builder));
        }
        CuratorFramework curator = builder.build();
        TracerDriver tracerDriver = optionalTracerDriverProvider.get();
        if (tracerDriver != null && curator.getZookeeperClient() != null) {
            curator.getZookeeperClient().setTracerDriver(tracerDriver);
        }
        curator.start();
        if (LogUtils.isTraceEnabled()) {
            LogUtils.trace((String)("blocking until connected to zookeeper for " + properties.getBlockUntilConnectedWait() + String.valueOf((Object)properties.getBlockUntilConnectedUnit())), (Object[])new Object[0]);
        }
        curator.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
        if (LogUtils.isTraceEnabled()) {
            LogUtils.trace((String)"connected to zookeeper", (Object[])new Object[0]);
        }
        return curator;
    }

    public static RetryPolicy retryPolicy(CuratorProperties properties) {
        return new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
    }
}

