/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.curator.actuator;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class CuratorHealthIndicator
extends AbstractHealthIndicator {
    private final CuratorFramework curatorFramework;

    public CuratorHealthIndicator(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            CuratorFrameworkState state = this.curatorFramework.getState();
            if (state != CuratorFrameworkState.STARTED) {
                builder.down().withDetail("error", (Object)"Client not started");
            } else if (this.curatorFramework.checkExists().forPath("/") == null) {
                builder.down().withDetail("error", (Object)"Root for namespace does not exist");
            } else {
                builder.up();
            }
            builder.withDetail("connectionString", (Object)this.curatorFramework.getZookeeperClient().getCurrentConnectionString()).withDetail("state", (Object)state);
        }
        catch (Exception e) {
            builder.down((Throwable)e);
        }
    }
}

