/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.curator.support;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.zookeeper.curator.lock.ZkLockType;
import com.taotao.boot.zookeeper.curator.support.CuratorOperations;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class CuratorTemplate
implements CuratorOperations {
    private final CuratorFramework curatorFramework;

    public CuratorTemplate(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    @Override
    public String createNode(String path, String data) throws Exception {
        return (String)this.curatorFramework.create().creatingParentsIfNeeded().forPath(path, data.getBytes());
    }

    @Override
    public String createTypeNode(CreateMode nodeType, String path, String data) throws Exception {
        return (String)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(nodeType)).forPath(path, data.getBytes());
    }

    @Override
    public String createTypeSeqNode(CreateMode nodeType, String path, String data) throws Exception {
        return (String)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withProtection().withMode(nodeType)).forPath(path, data.getBytes());
    }

    @Override
    public Stat setData(String path, String data) throws Exception {
        return (Stat)this.curatorFramework.setData().forPath(path, data.getBytes());
    }

    @Override
    public Stat setDataAsync(String path, String data, CuratorListener listener) throws Exception {
        this.curatorFramework.getCuratorListenable().addListener((Object)listener);
        return (Stat)((ErrorListenerPathAndBytesable)this.curatorFramework.setData().inBackground()).forPath(path, data.getBytes());
    }

    public Stat setDataAsync(String path, String data) throws Exception {
        return this.setDataAsync(path, data, (client, event) -> {});
    }

    @Override
    public void deleteNode(String path) throws Exception {
        this.curatorFramework.delete().deletingChildrenIfNeeded().forPath(path);
    }

    @Override
    public List<String> watchedGetChildren(String path) throws Exception {
        return (List)((BackgroundPathable)this.curatorFramework.getChildren().watched()).forPath(path);
    }

    @Override
    public List<String> watchedGetChildren(String path, Watcher watcher) throws Exception {
        return (List)((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher(watcher)).forPath(path);
    }

    @Override
    public InterProcessLock getLock(String path, ZkLockType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ZkLockType.LOCK -> new InterProcessMutex(this.curatorFramework, path);
            case ZkLockType.READ -> new InterProcessReadWriteLock(this.curatorFramework, path).readLock();
            case ZkLockType.WRITE -> new InterProcessReadWriteLock(this.curatorFramework, path).writeLock();
        };
    }

    public InterProcessLock getLock(String path) {
        return this.getLock(path, ZkLockType.LOCK);
    }

    public InterProcessLock getReadLock(String path) {
        return this.getLock(path, ZkLockType.READ);
    }

    public InterProcessLock getWriteLock(String path) {
        return this.getLock(path, ZkLockType.WRITE);
    }

    @Override
    public String getDistributedId(String path, String data) throws Exception {
        String seqNode = this.createTypeSeqNode(CreateMode.EPHEMERAL_SEQUENTIAL, "/" + path, data);
        LogUtils.info((String)seqNode, (Object[])new Object[0]);
        int index = seqNode.lastIndexOf(path);
        if (index >= 0) {
            return (index += path.length()) <= seqNode.length() ? seqNode.substring(index) : "";
        }
        return seqNode;
    }
}

