/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.original.api;

import com.taotao.boot.common.utils.log.LogUtils;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZkApi {
    private static final Logger logger = LoggerFactory.getLogger(ZkApi.class);
    private final ZooKeeper zkClient;

    public ZkApi(ZooKeeper zkClient) {
        this.zkClient = zkClient;
    }

    public Stat exists(String path, boolean needWatch) {
        try {
            return this.zkClient.exists(path, needWatch);
        }
        catch (Exception e) {
            logger.error("\u3010\u65ad\u6307\u5b9a\u8282\u70b9\u662f\u5426\u5b58\u5728\u5f02\u5e38\u3011{},{}", (Object)path, (Object)e);
            return null;
        }
    }

    public Stat exists(String path, Watcher watcher) {
        try {
            return this.zkClient.exists(path, watcher);
        }
        catch (Exception e) {
            logger.error("\u3010\u65ad\u6307\u5b9a\u8282\u70b9\u662f\u5426\u5b58\u5728\u5f02\u5e38\u3011{},{}", (Object)path, (Object)e);
            return null;
        }
    }

    public boolean createNode(String path, String data) {
        try {
            this.zkClient.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            return true;
        }
        catch (Exception e) {
            logger.error("\u3010\u521b\u5efa\u6301\u4e45\u5316\u8282\u70b9\u5f02\u5e38\u3011{},{},{}", new Object[]{path, data, e});
            return false;
        }
    }

    public boolean updateNode(String path, String data) {
        try {
            this.zkClient.setData(path, data.getBytes(), -1);
            return true;
        }
        catch (Exception e) {
            logger.error("\u3010\u4fee\u6539\u6301\u4e45\u5316\u8282\u70b9\u5f02\u5e38\u3011{},{},{}", new Object[]{path, data, e});
            return false;
        }
    }

    public boolean deleteNode(String path) {
        try {
            this.zkClient.delete(path, -1);
            return true;
        }
        catch (Exception e) {
            logger.error("\u3010\u5220\u9664\u6301\u4e45\u5316\u8282\u70b9\u5f02\u5e38\u3011{},{}", (Object)path, (Object)e);
            return false;
        }
    }

    public List<String> getChildren(String path) throws KeeperException, InterruptedException {
        return this.zkClient.getChildren(path, false);
    }

    public String getData(String path, Watcher watcher) {
        try {
            Stat stat = new Stat();
            byte[] bytes = this.zkClient.getData(path, watcher, stat);
            return new String(bytes);
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }
}

