/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.original.api.configuration;

import com.taotao.boot.zookeeper.original.api.properties.ZkProperties;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ZkProperties.class})
public class ZookeeperConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);

    @Bean(name={"zkClient"})
    public ZooKeeper zkClient(ZkProperties zkProperties) {
        ZooKeeper zooKeeper = null;
        try {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            zooKeeper = new ZooKeeper(zkProperties.getAddress(), zkProperties.getTimeout(), event -> {
                if (Watcher.Event.KeeperState.SyncConnected == event.getState()) {
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
            LOGGER.info("[\u521d\u59cb\u5316ZooKeeper\u8fde\u63a5\u72b6\u6001....]={}", (Object)zooKeeper.getState());
        }
        catch (Exception e) {
            LOGGER.error("[\u521d\u59cb\u5316ZooKeeper\u8fde\u63a5\u5f02\u5e38....]={}", (Object)e.getMessage(), (Object)e);
        }
        return zooKeeper;
    }
}

