/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.zookeeper.original.zkdist;

import com.taotao.boot.common.utils.log.LogUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class DistributedClient {
    private static final String connectString = "192.168.56.100:2181,192.168.56.101:2181,192.168.56.102:2181";
    private static final int sessionTimeout = 2000;
    private static final String parentNode = "/servers";
    private volatile List<String> serverList;
    private ZooKeeper zk = null;

    public void getConnect() throws Exception {
        this.zk = new ZooKeeper(connectString, 2000, new Watcher(){

            public void process(WatchedEvent event) {
                try {
                    DistributedClient.this.getServerList();
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        });
    }

    public void getServerList() throws Exception {
        List children = this.zk.getChildren(parentNode, true);
        ArrayList<String> servers = new ArrayList<String>();
        for (String child : children) {
            byte[] data = this.zk.getData("/servers/" + child, false, null);
            servers.add(new String(data));
        }
        this.serverList = servers;
        LogUtils.info((String)"serverList: {}", (Object[])new Object[]{this.serverList});
    }

    public void handleBussiness() throws InterruptedException {
        LogUtils.info((String)"client start working.....", (Object[])new Object[0]);
        Thread.sleep(Long.MAX_VALUE);
    }

    public static void main(String[] args) throws Exception {
        DistributedClient client = new DistributedClient();
        client.getConnect();
        client.getServerList();
        client.handleBussiness();
    }
}

